import numpy as np
import matplotlib.pyplot as plt

"""
On cherche à tracer par régression linéaire 
lnK° = a*1/T + b

Pensez à imprimer les résultats de la regression
ainsi que les valeurs numériques des grandeurs recherchées.

Saisir les points expérimentaux par des croix
Tracer la droite calculée par la régression

TB pour l'utilisation de la fonction np.polyfit (inv_T,ln_K,1)
1 donne le degré du polynôme

Penser à commenter le script

"""

T=np.array([700,800,900,1000,1200])    # température en K
K=np.array([0.003,0.03,0.77,12.2,760])  #constante d'équilibre

inv_T=1/T
ln_K=np.log(K)

coeffs=np.polyfit(inv_T,ln_K,1)
a,b=coeffs                         # a = pente, b = intersection à l'origine

lnKcalc = a*inv_T + b              # lnKcalc est la valeur calculée à partie de la régression


print('La pente est {:.1f} K^(-1)'.format(a))
print("L'ordonnée à l'origine est {:.3f} ".format(b))

R=8.314

delta_H=-a*R
delta_S=b*R

print('delta_H = {:.1f} J/mol)'.format(delta_H))
print('delta_S = {:.1f} J/(mol.K)'.format(delta_S))

plt.plot(inv_T, ln_K, "r+")              # r+ = croix rouge = point exp

plt.plot(inv_T, lnKcalc, 'b')            # droite de régression en bleu



plt.xlabel("1/T(K-1)")
plt.ylabel("ln(K)")
plt.show()
