# -*- coding: utf-8 -*-
"""
    Résolution numérique d'une équation différentielle d'ordre 2
    avec la fonction odeint de python (scipy).
    Ici, on utilise un pendule simple, sans amortissement.
    Equa diff : thetapointpoint +/- wo**2.theta = wo**2.grandtheta
    oscillateur harmonique +    theta(t) = A.cos(wot + phi) = B.cos(wot) + C.sin(wot)
    si - ...theta(t) = B.exp(wot) + C.exp(-wot)
    On peut évidemment remplacer theta par n'importe quelle autre variable !
"""

#### Importation des bibliothèques utiles

import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import odeint

#### Initialisations

# wo pulsation propre en rad/s
wo = 1


# Conditions initiales
grandtheta = 0                       # modélise une contrainte extérieure constante
theta0 = 2                          # angle initial en radian ou tension initiale en V
thetapoint0 = 0                      # vitesse angulaire initiale
y0 = [theta0, thetapoint0]           # vecteur initial

# Fonction intervenant dans l'équation différentielle vectorielle :
#     dy/dt = f(y, t) avec vecteur y = (theta, theta point)
def f(y, t) :                       # f(vecteur, temps)
    theta, thetapoint = y
    return [thetapoint, + wo**2*(theta-grandtheta)] # modifier le signe si nécessaire
# signe - pour l'oscillateur harmonique, signe + sinon

# Données pour l'expérience numérique
n = 1025                    # nombre de points de l'échantillonnage, puissance de 2 + 1
t0 = 0                      # instant initial en s
t1 = 4*2*np.pi/wo                     # instant final en s

#### Expérience numérique
t = np.linspace(t0, t1, n)
sol = odeint(f, y0, t)      # solution = liste des vecteurs pour chaque t

#### Tracés 
# theta(t) 
plt.figure(1)                                   # fenetrage
plt.plot(t, sol[:, 0])   #plt. instruction dans matplotlib.pyplot
                                                # syntaxe plot(liste des abscisses,liste ordonnées,...)
                                                # sol = liste des vecteurs solution
                                                # sol[:, 0] = liste des premières coordonnées des vecteurs de sol
                                                # _ : _ intervalle des valeurs de la liste = sous liste
plt.legend(loc='lower right')                   #légende en bas à droite
plt.xlabel('t (s)')                             #légende axe x
plt.ylabel('s (V)')                            
plt.grid()
plt.show()

