# -*- coding: utf-8 -*-
"""
Created on Mon Feb 27 15:31:44 2023

@author: Nicole
"""

import numpy as np
import matplotlib.pyplot as plt

""" Quelques constantes : 
"""
Ea = 80.e3          # énergie d'activation (J/mol)
k_0 = 1.e10         # facteur préexponentiel (sans unité)
R = 8.314           # constante des gaz parfaits (J/(mol.K))

""" 
Rôle de T sur X_A pour une réaction d'ordre 1 non renversable dans un RPAC : 
On définit deux fonctions
- la première est la constante de vitesse (loi d'Arrhénius) k(T)=koexp(-Ea / RT)
- la seconde donne le taux de conversion issu d'un bilan matière 
      X = k(T)*tau /(1+ k(T)*tau)
"""

def arrhenius(T,Ea,k_0):
    return k_0*np.exp(-Ea/R/T)

def taux_conv(T,Ea,k_0,tau):        #tau est le temps de passage
    return tau*arrhenius(T,Ea,k_0)/(1 + tau*arrhenius(T,Ea,k_0))

T=np.linspace(200,600,500)  #Choix d'un intervalle de température

"""
Dessins du taux de conversion en fonction de la température 
pour différentes valeurs du temps de passage
"""
plt.figure()
plt.plot(T,taux_conv(T,Ea,k_0,1),label=u"$\\tau = 1$ s")
plt.plot(T,taux_conv(T,Ea,k_0,10),label=u"$\\tau=10$ s")
plt.plot(T,taux_conv(T,Ea,k_0,100),label=u"$\\tau=100$ s")
plt.xlabel("$T$ (en K)")
plt.ylabel("$X_A$")
plt.legend()
plt.grid(which='both')
plt.show()
