# -*- coding: utf-8 -*-
"""
Created on Mon Feb 27 15:56:18 2023

@author: Nicole
"""


# -*- coding: utf-8 -*-
"""
Created on Mon Feb 27 15:28:15 2023

@author: Nicole
"""


import numpy as np
import matplotlib.pyplot as plt


""" Quelques constantes : 
"""
Ea = 80.e3          # énergie d'activation
k_0 = 1.e10         # facteur préexponentiel
R = 8.314           # constante des gaz parfaits

""" 
Rôle de T sur X_A pour une réaction d'ordre 1 non renversable dans un RPAC : 
On définit deux fonctions
- la première est la constante de vitesse (loi d'Arrhénius)
- la seconde donne le taux de conversion issu d'un bilan matière
"""

def arrhenius(T,Ea,k_0):
    return k_0*np.exp(-Ea/R/T)

def taux_conv(T,Ea,k_0,tau):        #tau est le temps de passage
    return tau*arrhenius(T,Ea,k_0)/(1 + tau*arrhenius(T,Ea,k_0))

T=np.linspace(200,600,500)  #Choix d'un intervalle de température

"""
Effets thermiques : marche adiabatique du RPAC
On définit une 3è fonction (endo) qui vient du bilan enthalpique X(T) = ga ( T - To)
ga < 0 pour une réaction endothermique T < To ; ga > 0 si exothermique T > To.
"""

def endo(T,T_0,ga):
    return ga*(T-T_0)

"""
Cas où la réaction est endothermique, tau = 10 s. 
Deux températures de départ sont envisagées : 400 K et 550 K
et la même pente de ga = - 0.03 SI
On repère à l'œil le point de fonctionnement
"""
plt.figure()
plt.plot(T,taux_conv(T,Ea,k_0,10), label=u"$\\tau=10$ s")
plt.plot(T,endo(T,550,-0.03), label=u"Te = 550 K")
plt.plot(T,endo(T,400,-0.03),  label=u"Te = 400 K")
plt.ylim([0,1])
plt.xlim([200,600])
plt.xlabel("$T$ (en K)")
plt.ylabel("$X_A$")
plt.legend()
plt.grid(which='both')
plt.show()
