# -*- coding: utf-8 -*-
"""
Created on Mon Feb 27 16:16:22 2023

@author: Nicole
"""


# -*- coding: utf-8 -*-
"""
Created on Mon Feb 27 15:28:15 2023

@author: Nicole
"""


import numpy as np
import matplotlib.pyplot as plt
import scipy.optimize as sciopt

""" Quelques constantes : 
"""
Ea = 70.e3          # énergie d'activation
k_0 = 2.e8         # facteur préexponentiel
R = 8.314           # constante des gaz parfaits

""" 
Rôle de T sur X_A pour une réaction d'ordre 1 non renversable dans un RPAC : 
On définit deux fonctions
- la première est la constante de vitesse (loi d'Arrhénius)
- la seconde donne le taux de conversion issu d'un bilan matière
"""

def arrhenius(T,Ea,k_0):
    return k_0*np.exp(-Ea/R/T)

def taux_conv(T,Ea,k_0,tau):        #tau est le temps de passage
    return tau*arrhenius(T,Ea,k_0)/(1 + tau*arrhenius(T,Ea,k_0))

T=np.linspace(200,600,500)  #Choix d'un intervalle de température

def endo(T,T_0,ga):
    return ga*(T-T_0)

"""
Cas où la réaction est exothermique
Nouvelles valeurs de l'énergie d'activation et du facteur de fréquence
Sur les graphes suivants, on repère visuellement le ou les points de fonctionnement
"""

# rôle de la température à l'entrée du réacteur
plt.figure()
plt.plot(T,taux_conv(T,Ea,k_0,1), label=u"$\\tau=1$ s")
plt.plot(T,endo(T,314,0.005),label=u"Te = 314 K")
plt.plot(T,endo(T,340,0.005),label=u"Te = 340 K")
plt.plot(T,endo(T,375,0.005),label=u"Te = 375 K")
plt.ylim([0,1])
plt.xlim([200,600])
plt.xlabel("$T$ (en K)")
plt.ylabel("$X_A$")
plt.legend()
plt.grid(which='both')
plt.show()

# rôle de la pente
plt.figure()
plt.plot(T,taux_conv(T,Ea,k_0,1),label=u"$\\tau=1$ s")
plt.plot(T,endo(T,314,0.005),label=u" pente 0,005 SI")
plt.plot(T,endo(T,314,0.01),label=u" pente 0,01 SI")
plt.plot(T,endo(T,314,0.0035),label=u" pente 0,0035 SI")
plt.ylim([0,1])
plt.xlim([200,600])
plt.xlabel("$T$ (en K)")
plt.ylabel("$X_A$")
plt.legend()
plt.grid(which='both')
plt.show()