# -*- coding: utf-8 -*-
"""
Created on Mon Feb 27 15:31:44 2023

@author: Nicole
"""

import numpy as np
import matplotlib.pyplot as plt

"""
Rôle du temps de passage sur X_A pour une réaction d'ordre 1 non renversable dans un RPAC : 
      X = k(T)*tau /(1+ k(T)*tau)
"""
k = 0.353           # constante de vitesse en s-1

def X(tau):        #tau est le temps de passage
    return tau*k/(1 + tau*k)

tau=np.linspace(0,100,500)  #Choix d'un intervalle de temps

"""
Graphe du taux de conversion en fonction du temps de passage
"""
plt.figure()
plt.plot(tau,X(tau), label='ordre 1 k = 0,353 s-1')
plt.xlabel("$tau$ (en s)")
plt.ylabel("$X_A$")
plt.legend()
plt.grid(which='both')
plt.show()
